/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class WorldHeightManager {
    private final Map<String, WorldHeightConfig> worldHeights = new HashMap<String, WorldHeightConfig>();
    private WorldHeightConfig defaultNormal;
    private WorldHeightConfig defaultNether;
    private WorldHeightConfig defaultEnd;

    public void load(ConfigurationSection section) {
        this.worldHeights.clear();
        if (section == null) {
            this.loadDefaults();
            return;
        }
        ConfigurationSection normalSection = section.getConfigurationSection("normal");
        this.defaultNormal = normalSection != null ? this.loadWorldHeightConfig(normalSection) : new WorldHeightConfig("normal", 60, 256);
        ConfigurationSection netherSection = section.getConfigurationSection("nether");
        this.defaultNether = netherSection != null ? this.loadWorldHeightConfig(netherSection) : new WorldHeightConfig("nether", 32, 100);
        ConfigurationSection endSection = section.getConfigurationSection("end");
        this.defaultEnd = endSection != null ? this.loadWorldHeightConfig(endSection) : new WorldHeightConfig("the_end", 40, 80);
        ConfigurationSection customWorldsSection = section.getConfigurationSection("custom-worlds");
        if (customWorldsSection != null) {
            for (String worldName : customWorldsSection.getKeys(false)) {
                ConfigurationSection worldSection = customWorldsSection.getConfigurationSection(worldName);
                if (worldSection == null) continue;
                WorldHeightConfig config = this.loadWorldHeightConfig(worldSection);
                config.setWorldName(worldName);
                this.worldHeights.put(worldName.toLowerCase(), config);
            }
        }
    }

    private void loadDefaults() {
        this.defaultNormal = new WorldHeightConfig("normal", 60, 256);
        this.defaultNether = new WorldHeightConfig("nether", 32, 100);
        this.defaultEnd = new WorldHeightConfig("the_end", 40, 80);
    }

    private WorldHeightConfig loadWorldHeightConfig(ConfigurationSection section) {
        String type = section.getString("type", "normal");
        int minY = section.getInt("min", this.getDefaultMinForType(type));
        int maxY = section.getInt("max", this.getDefaultMaxForType(type));
        boolean useDefaultAlgorithm = section.getBoolean("use-default-algorithm", true);
        return new WorldHeightConfig(type, minY, maxY, useDefaultAlgorithm);
    }

    private int getDefaultMinForType(String type) {
        return switch (type.toLowerCase()) {
            case "nether" -> 32;
            case "the_end", "end" -> 40;
            default -> 60;
        };
    }

    private int getDefaultMaxForType(String type) {
        return switch (type.toLowerCase()) {
            case "nether" -> 100;
            case "the_end", "end" -> 80;
            default -> 256;
        };
    }

    public WorldHeightConfig getHeightConfigForWorld(World world) {
        String worldName = world.getName().toLowerCase();
        if (this.worldHeights.containsKey(worldName)) {
            return this.worldHeights.get(worldName);
        }
        return switch (world.getEnvironment()) {
            case World.Environment.NETHER -> this.defaultNether;
            case World.Environment.THE_END -> this.defaultEnd;
            default -> this.defaultNormal;
        };
    }

    public int getMinYForWorld(World world) {
        return this.getHeightConfigForWorld(world).getMinY();
    }

    public int getMaxYForWorld(World world) {
        return this.getHeightConfigForWorld(world).getMaxY();
    }

    public boolean shouldUseDefaultAlgorithm(World world) {
        return this.getHeightConfigForWorld(world).isUseDefaultAlgorithm();
    }

    public Map<String, WorldHeightConfig> getWorldHeights() {
        return this.worldHeights;
    }

    public WorldHeightConfig getDefaultNormal() {
        return this.defaultNormal;
    }

    public WorldHeightConfig getDefaultNether() {
        return this.defaultNether;
    }

    public WorldHeightConfig getDefaultEnd() {
        return this.defaultEnd;
    }

    public static class WorldHeightConfig {
        private final String worldType;
        private String worldName;
        private final int minY;
        private final int maxY;
        private final boolean useDefaultAlgorithm;

        public WorldHeightConfig(String worldType, int minY, int maxY) {
            this(worldType, minY, maxY, true);
        }

        public WorldHeightConfig(String worldType, int minY, int maxY, boolean useDefaultAlgorithm) {
            this.worldType = worldType;
            this.minY = minY;
            this.maxY = maxY;
            this.useDefaultAlgorithm = useDefaultAlgorithm;
        }

        public void setWorldName(String worldName) {
            this.worldName = worldName;
        }

        public String getDisplayName() {
            return this.worldName != null ? this.worldName : this.worldType;
        }

        public String getWorldType() {
            return this.worldType;
        }

        public String getWorldName() {
            return this.worldName;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public boolean isUseDefaultAlgorithm() {
            return this.useDefaultAlgorithm;
        }
    }
}

