/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.\u0441ore.managers.WorldHeightManager;

public class SpawnManager {
    private int minX = -2000;
    private int maxX = 2000;
    private int minZ = -2000;
    private int maxZ = 2000;
    private ConfigManager configManager;

    public void load(ConfigurationSection section, ConfigManager configManager) {
        this.configManager = configManager;
        if (section == null) {
            this.setDefaultValues();
            return;
        }
        this.minX = section.getInt("minx", -2000);
        this.maxX = section.getInt("maxx", 2000);
        this.minZ = section.getInt("minz", -2000);
        this.maxZ = section.getInt("maxz", 2000);
    }

    private void setDefaultValues() {
        this.minX = -2000;
        this.maxX = 2000;
        this.minZ = -2000;
        this.maxZ = 2000;
    }

    public Location getRandomSafeLocation(World world, Random random) {
        if (this.configManager == null) {
            throw new IllegalStateException("ConfigManager \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d. \u0412\u044b\u0437\u043e\u0432\u0438\u0442\u0435 load() \u0441 ConfigManager.");
        }
        for (int i = 0; i < 50; ++i) {
            Location location;
            int z;
            int x = random.nextInt(this.maxX - this.minX + 1) + this.minX;
            int y = this.getSuitableHeight(world, x, z = random.nextInt(this.maxZ - this.minZ + 1) + this.minZ, random);
            if (y == Integer.MIN_VALUE || !this.isLocationSafe(location = new Location(world, (double)x, (double)y, (double)z))) continue;
            return location;
        }
        return null;
    }

    public int getSuitableHeight(World world, int x, int z, Random random) {
        if (this.configManager == null || this.configManager.getWorldHeightManager() == null) {
            return this.getSuitableHeightLegacy(world, x, z);
        }
        WorldHeightManager.WorldHeightConfig heightConfig = this.configManager.getWorldHeightManager().getHeightConfigForWorld(world);
        if (!heightConfig.isUseDefaultAlgorithm()) {
            int maxY;
            int minY = Math.max(heightConfig.getMinY(), world.getMinHeight());
            if (minY >= (maxY = Math.min(heightConfig.getMaxY(), world.getMaxHeight()))) {
                return minY;
            }
            return random.nextInt(maxY - minY + 1) + minY;
        }
        World.Environment env = world.getEnvironment();
        switch (env) {
            case NORMAL: {
                return this.getSurfaceHeight(world, x, z, heightConfig);
            }
            case NETHER: {
                return this.getNetherHeight(world, x, z, heightConfig);
            }
            case THE_END: {
                return this.getEndHeight(world, x, z, heightConfig);
            }
        }
        return this.getSurfaceHeight(world, x, z, heightConfig);
    }

    private int getSuitableHeightLegacy(World world, int x, int z) {
        World.Environment env = world.getEnvironment();
        switch (env) {
            case NORMAL: {
                return this.getSurfaceHeightLegacy(world, x, z);
            }
            case NETHER: {
                return this.getNetherHeightLegacy(world, x, z);
            }
            case THE_END: {
                return this.getEndHeightLegacy(world, x, z);
            }
        }
        return this.getSurfaceHeightLegacy(world, x, z);
    }

    private int getSurfaceHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        Material typeBelow;
        Material type;
        int maxY;
        int y;
        int minY = Math.max(config.getMinY(), world.getMinHeight());
        for (y = maxY = Math.min(config.getMaxY(), world.getMaxHeight()); y >= minY; --y) {
            type = world.getBlockAt(x, y, z).getType();
            typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type)) continue;
            return y;
        }
        for (y = maxY; y >= minY; --y) {
            type = world.getBlockAt(x, y, z).getType();
            typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !type.isAir()) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    private int getSurfaceHeightLegacy(World world, int x, int z) {
        for (int y = world.getHighestBlockYAt(x, z); y > world.getMinHeight(); --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type)) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    private int getNetherHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        Material type;
        int y;
        int minY = Math.max(config.getMinY(), world.getMinHeight());
        int maxY = Math.min(config.getMaxY(), world.getMaxHeight());
        for (y = minY; y <= maxY; ++y) {
            type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type) || !this.isAirOrReplaceable(typeAbove)) continue;
            return y;
        }
        for (y = minY; y <= maxY; ++y) {
            type = world.getBlockAt(x, y, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !type.isAir()) continue;
            return y;
        }
        return (minY + maxY) / 2;
    }

    private int getNetherHeightLegacy(World world, int x, int z) {
        for (int y = 32; y <= 100; ++y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type) || !this.isAirOrReplaceable(typeAbove)) continue;
            return y;
        }
        return 64;
    }

    private int getEndHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        Material type;
        int maxY;
        int y;
        int minY = Math.max(config.getMinY(), world.getMinHeight());
        for (y = maxY = Math.min(config.getMaxY(), world.getMaxHeight()); y >= minY; --y) {
            type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            if (type != Material.END_STONE && type != Material.OBSIDIAN || !this.isAirOrReplaceable(typeAbove)) continue;
            return y + 1;
        }
        for (y = maxY; y >= minY; --y) {
            type = world.getBlockAt(x, y, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !type.isAir()) continue;
            return y;
        }
        return (minY + maxY) / 2;
    }

    private int getEndHeightLegacy(World world, int x, int z) {
        int mainHeight;
        for (int y = mainHeight = 65; y >= world.getMinHeight(); --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            if (type != Material.END_STONE && type != Material.OBSIDIAN || !this.isAirOrReplaceable(typeAbove)) continue;
            return y + 1;
        }
        return mainHeight + 1;
    }

    private boolean isSolidGround(Material material) {
        boolean isVegetationOrDecor;
        if (material.isAir() || material == Material.WATER || material == Material.LAVA || material == Material.CAVE_AIR || material == Material.VOID_AIR) {
            return false;
        }
        String materialName = material.name().toUpperCase();
        boolean bl = isVegetationOrDecor = materialName.endsWith("_LEAVES") || materialName.endsWith("_LOG") || materialName.endsWith("_WOOD") || materialName.endsWith("_PLANKS") || materialName.endsWith("_SAPLING") || materialName.endsWith("_FUNGUS") || materialName.contains("MUSHROOM") || materialName.contains("VINE") || materialName.contains("CORAL") || materialName.contains("KELP") || materialName.contains("SEAGRASS") || material == Material.GRASS || material == Material.TALL_GRASS || material == Material.FERN || material == Material.LARGE_FERN || material == Material.DEAD_BUSH || material == Material.SUGAR_CANE || material == Material.BAMBOO || material == Material.SWEET_BERRY_BUSH;
        if (isVegetationOrDecor) {
            return false;
        }
        return material.isSolid() && material.isBlock() && !material.isTransparent() && material.getBlastResistance() > 0.0f;
    }

    private boolean isAirOrReplaceable(Material material) {
        if (material.isAir()) {
            return true;
        }
        String materialName = material.name().toUpperCase();
        return materialName.endsWith("_LEAVES") || material == Material.TALL_GRASS || material == Material.GRASS || material == Material.FERN || material == Material.LARGE_FERN || material == Material.DEAD_BUSH || material == Material.SUGAR_CANE || material == Material.BAMBOO || material == Material.SNOW || material == Material.VINE || !material.isSolid();
    }

    private boolean isLocationSafe(Location location) {
        if (location.getY() <= (double)location.getWorld().getMinHeight() || location.getY() >= (double)location.getWorld().getMaxHeight()) {
            return false;
        }
        Material type = location.getBlock().getType();
        Material typeBelow = location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType();
        boolean isSpawnPointSafe = type.isAir() || type == Material.CAVE_AIR || type == Material.VOID_AIR || this.isAirOrReplaceable(type);
        boolean isGroundSolid = this.isSolidGround(typeBelow);
        boolean noLiquidAbove = true;
        boolean noLavaNearby = true;
        for (int dx = -1; dx <= 1; ++dx) {
            block1: for (int dy = -1; dy <= 2; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Material nearby;
                    if (dx == 0 && dy == 0 && dz == 0 || (nearby = location.clone().add((double)dx, (double)dy, (double)dz).getBlock().getType()) != Material.LAVA && nearby != Material.WATER) continue;
                    noLavaNearby = false;
                    continue block1;
                }
            }
        }
        return isSpawnPointSafe && isGroundSolid && noLiquidAbove && noLavaNearby;
    }

    public boolean isWithinBounds(int x, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
    }

    public Location getCenter(World world) {
        int centerX = (this.minX + this.maxX) / 2;
        int centerZ = (this.minZ + this.maxZ) / 2;
        int y = world.getHighestBlockYAt(centerX, centerZ);
        return new Location(world, (double)centerX, (double)y, (double)centerZ);
    }

    public Location getRandomPoint(World world, Random random) {
        int x = random.nextInt(this.maxX - this.minX + 1) + this.minX;
        int z = random.nextInt(this.maxZ - this.minZ + 1) + this.minZ;
        int y = world.getHighestBlockYAt(x, z);
        return new Location(world, (double)x, (double)y, (double)z);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

