/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import ru.truhot.rdang.util.MessageUtil;

public class MessageManager {
    private List<String> openDungMessages = new ArrayList<String>();
    private String saveKeyMessage = "";
    private List<String> closedDungMessages = new ArrayList<String>();

    public void load(ConfigurationSection section) {
        if (section == null) {
            this.setDefaultMessages();
            return;
        }
        this.openDungMessages = MessageUtil.colorize(section.getStringList("openDung"));
        this.saveKeyMessage = MessageUtil.colorize(section.getString("saveKey", "&a\u0422\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u043b \u043a\u043b\u044e\u0447"));
        this.closedDungMessages = MessageUtil.colorize(section.getStringList("closedDung"));
        if (this.openDungMessages.isEmpty()) {
            this.openDungMessages = MessageUtil.colorize(List.of("", "&e\u0418\u0433\u0440\u043e\u043a &6{player} &e\u043e\u0442\u043a\u0440\u044b\u043b \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435", ""));
        }
        if (this.closedDungMessages.isEmpty()) {
            this.closedDungMessages = MessageUtil.colorize(List.of("", "&c\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e!!", ""));
        }
    }

    private void setDefaultMessages() {
        this.openDungMessages = MessageUtil.colorize(List.of("", "&e\u0418\u0433\u0440\u043e\u043a &6{player} &e\u043e\u0442\u043a\u0440\u044b\u043b \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435", ""));
        this.saveKeyMessage = MessageUtil.colorize("&a\u0422\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u043b \u043a\u043b\u044e\u0447");
        this.closedDungMessages = MessageUtil.colorize(List.of("", "&c\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e!!", ""));
    }

    public List<String> getFormattedOpenDungMessages(String playerName) {
        ArrayList<String> formatted = new ArrayList<String>();
        for (String message : this.openDungMessages) {
            formatted.add(message.replace("{player}", playerName));
        }
        return formatted;
    }

    public List<String> getOpenDungMessages() {
        return this.openDungMessages;
    }

    public String getSaveKeyMessage() {
        return this.saveKeyMessage;
    }

    public List<String> getClosedDungMessages() {
        return this.closedDungMessages;
    }
}

