/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.truhot.rdang.storage.Storage;

public class LootManager {
    private final Storage items;
    private final Random random = new Random();

    public LootManager(Storage items) {
        this.items = items;
    }

    public void fillInventoryWithRandomLoot(Inventory inventory) {
        ConfigurationSection itemsSection = this.items.getConfig().getConfigurationSection("items");
        if (itemsSection != null) {
            ArrayList<Integer> availableSlots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSize(); ++i) {
                availableSlots.add(i);
            }
            for (String itemId : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemId);
                ItemStack item = itemSection.getItemStack("item");
                item.setAmount(this.getRandomNumber(itemSection.getInt("minAmount"), itemSection.getInt("maxAmount")));
                double chance = itemSection.getDouble("chance");
                if (!(Math.random() * 100.0 < chance) || availableSlots.isEmpty()) continue;
                int randomSlotIndex = this.random.nextInt(availableSlots.size());
                int slot = (Integer)availableSlots.get(randomSlotIndex);
                inventory.setItem(slot, item);
                availableSlots.remove(randomSlotIndex);
            }
        } else {
            this.items.getConfig().createSection("items");
        }
    }

    public void addItem(String id, ItemStack item, int chance, int minAmount, int maxAmount) {
        ConfigurationSection itemsSection = this.items.getConfig().getConfigurationSection("items");
        if (itemsSection == null) {
            this.items.getConfig().createSection("items");
            this.addItem(id, item, chance, minAmount, maxAmount);
        } else {
            itemsSection = itemsSection.createSection(String.valueOf(id));
            itemsSection.set("item", (Object)item);
            itemsSection.set("chance", (Object)chance);
            itemsSection.set("minAmount", (Object)minAmount);
            itemsSection.set("maxAmount", (Object)maxAmount);
            this.items.save();
        }
    }

    public int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }
}

