/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import ru.truhot.rdang.util.HeadUtil;
import ru.truhot.rdang.util.MessageUtil;

public class ItemManager {
    private ItemStack key;
    private ItemStack compass;
    private int spawnChance = 10;
    private int saveChance = 10;
    private boolean hideEnchantments = false;

    public void load(ConfigurationSection section) {
        if (section == null) {
            this.createDefaultKey();
            this.createDefaultCompass();
            return;
        }
        ConfigurationSection keySection = section.getConfigurationSection("key");
        if (keySection != null) {
            this.key = this.loadItemFromConfig(keySection, Material.PRISMARINE_SHARD, "\u041a\u043b\u044e\u0447 \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430");
            this.spawnChance = keySection.getInt("chanceSpawn", 10);
            this.saveChance = keySection.getInt("saveChance", 10);
            this.hideEnchantments = keySection.getBoolean("hideEnchantments", false);
        } else {
            this.createDefaultKey();
        }
        ConfigurationSection compassSection = section.getConfigurationSection("compass");
        if (compassSection != null) {
            ItemMeta meta;
            this.compass = this.loadItemFromConfig(compassSection, Material.COMPASS, "&b\u041a\u043e\u043c\u043f\u0430\u0441");
            if (this.compass != null && (meta = this.compass.getItemMeta()) != null) {
                NamespacedKey compassKey = new NamespacedKey("rdang", "compass");
                meta.getPersistentDataContainer().set(compassKey, PersistentDataType.STRING, (Object)"true");
                this.compass.setItemMeta(meta);
            }
        } else {
            this.createDefaultCompass();
        }
    }

    private ItemStack loadItemFromConfig(ConfigurationSection section, Material defaultMaterial, String defaultName) {
        ItemStack item;
        ItemMeta meta;
        String materialName = section.getString("material", defaultMaterial.name());
        if (HeadUtil.isBase64Head(materialName)) {
            return this.createSkullFromBase64(materialName, section, defaultName);
        }
        Material material = this.getMaterialFromString(materialName);
        if (material == null) {
            material = defaultMaterial;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            boolean itemHideEnchantments;
            this.applyItemMeta(meta, section, defaultName);
            if (defaultMaterial == Material.PRISMARINE_SHARD) {
                NamespacedKey nbtKey = new NamespacedKey("rdang", "key");
                meta.getPersistentDataContainer().set(nbtKey, PersistentDataType.STRING, (Object)"holyworld");
            }
            if (defaultMaterial == Material.COMPASS) {
                NamespacedKey compassKey = new NamespacedKey("rdang", "compass");
                meta.getPersistentDataContainer().set(compassKey, PersistentDataType.STRING, (Object)"true");
            }
            if (!(itemHideEnchantments = section.getBoolean("hideEnchantments", this.hideEnchantments))) {
                meta.addEnchant(Enchantment.LUCK, 1, true);
            }
            if (itemHideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createSkullFromBase64(String base64WithPrefix, ConfigurationSection section, String defaultName) {
        boolean itemHideEnchantments;
        ItemStack skull = HeadUtil.createSkullFromPrefixedString(base64WithPrefix);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta == null) {
            return skull;
        }
        this.applyItemMeta((ItemMeta)meta, section, defaultName);
        if (defaultName.equals("\u041a\u043b\u044e\u0447 \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430")) {
            NamespacedKey nbtKey = new NamespacedKey("rdang", "key");
            meta.getPersistentDataContainer().set(nbtKey, PersistentDataType.STRING, (Object)"holyworld");
        }
        if (defaultName.equals("&b\u041a\u043e\u043c\u043f\u0430\u0441")) {
            NamespacedKey compassKey = new NamespacedKey("rdang", "compass");
            meta.getPersistentDataContainer().set(compassKey, PersistentDataType.STRING, (Object)"true");
        }
        if (!(itemHideEnchantments = section.getBoolean("hideEnchantments", this.hideEnchantments))) {
            meta.addEnchant(Enchantment.LUCK, 1, true);
        }
        if (itemHideEnchantments) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private void applyItemMeta(ItemMeta meta, ConfigurationSection section, String defaultName) {
        String name = section.getString("name", defaultName);
        meta.setDisplayName(MessageUtil.colorize(name));
        List<String> lore = section.getStringList("lore");
        if (lore.isEmpty()) {
            lore = defaultName.equals("&b\u041a\u043e\u043c\u043f\u0430\u0441") ? List.of("", "\u00a7fdbekasov11 \u0433\u043e \u043d\u0430 \u0440\u0443\u0445\u0430\u0439\u043f\u0438\u043a\u0441\u0438\u043b\u044c?", "") : List.of("", "\u00a7fdbekasov11 \u0433\u043e \u043d\u0430 \u0440\u0443\u0445\u0430\u0439\u043f\u0438\u043a\u0441\u0438\u043b\u044c?", "");
        }
        meta.setLore(lore.stream().map(MessageUtil::colorize).collect(Collectors.toList()));
    }

    private void createDefaultKey() {
        ItemStack item = new ItemStack(Material.PRISMARINE_SHARD);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtil.colorize("\u041a\u043b\u044e\u0447 \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430"));
            meta.setLore(MessageUtil.colorize(List.of("", "\u00a7fdbekasov11 \u0433\u043e \u043d\u0430 \u0440\u0443\u0445\u0430\u0439\u043f\u0438\u043a\u0441\u0438\u043b\u044c?", "")));
            NamespacedKey nbtKey = new NamespacedKey("rdang", "key");
            meta.getPersistentDataContainer().set(nbtKey, PersistentDataType.STRING, (Object)"holyworld");
            if (!this.hideEnchantments) {
                meta.addEnchant(Enchantment.LUCK, 1, true);
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        this.key = item;
        this.spawnChance = 10;
        this.saveChance = 10;
    }

    private void createDefaultCompass() {
        ItemStack item = new ItemStack(Material.COMPASS);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtil.colorize("&b\u041a\u043e\u043c\u043f\u0430\u0441"));
            meta.setLore(MessageUtil.colorize(List.of("", "\u00a7fdbekasov11 \u0433\u043e \u043d\u0430 \u0440\u0443\u0445\u0430\u0439\u043f\u0438\u043a\u0441\u0438\u043b\u044c?", "")));
            NamespacedKey compassKey = new NamespacedKey("rdang", "compass");
            meta.getPersistentDataContainer().set(compassKey, PersistentDataType.STRING, (Object)"true");
            if (!this.hideEnchantments) {
                meta.addEnchant(Enchantment.LUCK, 1, true);
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        this.compass = item;
    }

    private Material getMaterialFromString(String materialName) {
        if (materialName == null || materialName.isEmpty()) {
            return null;
        }
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        if (material != null) {
            return material;
        }
        String formattedName = materialName.toUpperCase().replace(' ', '_');
        return Material.getMaterial((String)formattedName);
    }

    public ItemStack getKey() {
        return this.key;
    }

    public ItemStack getCompass() {
        return this.compass;
    }

    public int getSpawnChance() {
        return this.spawnChance;
    }

    public int getSaveChance() {
        return this.saveChance;
    }

    public boolean isHideEnchantments() {
        return this.hideEnchantments;
    }
}

