/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.UndoUtil;
import ru.truhot.rdang.\u0441ore.managers.ItemChecker;
import ru.truhot.rdang.\u0441ore.managers.ShulkerManager;

public class EventManager
implements Listener {
    private final Storage shulkers;
    private final ConfigManager configManager;
    private final ShulkerManager shulkerManager;
    private final ItemChecker itemChecker;
    private final Random random = new Random();
    private final UndoUtil undoUtil;

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ConfigurationSection locsSection = this.shulkers.getConfig().getConfigurationSection("locs");
        if (locsSection != null && event.getClickedBlock() != null && this.shulkerManager.isShulker(event.getClickedBlock())) {
            for (String itemId : locsSection.getKeys(false)) {
                ConfigurationSection shulker = locsSection.getConfigurationSection(itemId);
                Location shulkerLocation = shulker.getLocation("location");
                if (event.getClickedBlock().getLocation().getBlockX() != shulkerLocation.getBlockX() || event.getClickedBlock().getLocation().getBlockY() != shulkerLocation.getBlockY() || event.getClickedBlock().getLocation().getBlockZ() != shulkerLocation.getBlockZ() || !event.getClickedBlock().getLocation().getWorld().getName().equals(shulkerLocation.getWorld().getName()) || shulker.getBoolean("opened")) continue;
                ItemStack itemInHand = event.getPlayer().getItemInHand();
                if (itemInHand != null && itemInHand.getType() != Material.AIR && itemInHand.getItemMeta() != null) {
                    if (this.itemChecker.isValidKey(itemInHand)) {
                        Particle particleType;
                        String particleTypeStr = this.configManager.getShulker().getString("particles.type", "TOTEM");
                        try {
                            particleType = Particle.valueOf((String)particleTypeStr.toUpperCase());
                        }
                        catch (IllegalArgumentException var25) {
                            particleType = Particle.TOTEM;
                        }
                        int particleCount = this.configManager.getShulker().getInt("particles.count", 20);
                        double offsetX = this.configManager.getShulker().getDouble("particles.offsetX", 1.5);
                        double offsetY = this.configManager.getShulker().getDouble("particles.offsetY", 1.5);
                        double offsetZ = this.configManager.getShulker().getDouble("particles.offsetZ", 1.5);
                        double particleExtra = this.configManager.getShulker().getDouble("particles.extra", 0.1);
                        String openSoundStr = this.configManager.getShulker().getString("sounds.openSound", "UI_TOAST_CHALLENGE_COMPLETE");
                        try {
                            Sound openSound = Sound.valueOf((String)openSoundStr.toUpperCase());
                            float volume = (float)this.configManager.getShulker().getInt("sounds.volume", 50) / 100.0f;
                            float pitch = (float)this.configManager.getShulker().getDouble("sounds.pitch", 1.0);
                            shulkerLocation.getWorld().playSound(shulkerLocation, openSound, volume, pitch);
                        }
                        catch (IllegalArgumentException var24) {
                            shulkerLocation.getWorld().playSound(shulkerLocation, Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.5f, 1.0f);
                        }
                        shulkerLocation.getWorld().spawnParticle(particleType, shulkerLocation.clone().add(0.5, 1.0, 0.5), particleCount, offsetX, offsetY, offsetZ, particleExtra);
                        shulkerLocation.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, shulkerLocation.clone().add(0.5, 1.0, 0.5), 10, 0.5, 2.0, 0.5, 0.1);
                        shulker.set("opened", (Object)true);
                        this.shulkers.save();
                        this.checkAndScheduleCleanup(shulkerLocation);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            for (String s : this.configManager.getMessageManager().getFormattedOpenDungMessages(event.getPlayer().getName())) {
                                player.sendMessage(s);
                            }
                        }
                        int saveChance = this.configManager.getItemManager().getSaveChance();
                        if (Math.random() * 100.0 < (double)saveChance) {
                            event.getPlayer().sendMessage(this.configManager.getMessageManager().getSaveKeyMessage());
                        } else {
                            ItemStack hand = event.getPlayer().getItemInHand();
                            if (hand.getAmount() > 1) {
                                hand.setAmount(hand.getAmount() - 1);
                            } else {
                                event.getPlayer().setItemInHand(new ItemStack(Material.AIR));
                            }
                        }
                        return;
                    }
                    for (String s : this.configManager.getMessageManager().getClosedDungMessages()) {
                        event.getPlayer().sendMessage(s);
                    }
                    String lockedSoundStr = this.configManager.getShulker().getString("sounds.lockedSound", "BLOCK_BARREL_CLOSE");
                    try {
                        Sound lockedSound = Sound.valueOf((String)lockedSoundStr.toUpperCase());
                        float volume = (float)this.configManager.getShulker().getInt("sounds.volume", 50) / 100.0f;
                        float pitch = (float)this.configManager.getShulker().getDouble("sounds.pitch", 1.0);
                        event.getPlayer().playSound(event.getPlayer().getLocation(), lockedSound, volume, pitch);
                        shulkerLocation.getWorld().playSound(shulkerLocation, lockedSound, volume * 0.5f, pitch * 0.8f);
                    }
                    catch (IllegalArgumentException var26) {
                        event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.BLOCK_BARREL_CLOSE, 0.5f, 1.0f);
                    }
                    event.setCancelled(true);
                    return;
                }
                for (String s : this.configManager.getMessageManager().getClosedDungMessages()) {
                    event.getPlayer().sendMessage(s);
                }
                String lockedSoundStr = this.configManager.getShulker().getString("sounds.lockedSound", "BLOCK_BARREL_CLOSE");
                try {
                    Sound lockedSound = Sound.valueOf((String)lockedSoundStr.toUpperCase());
                    float volume = (float)this.configManager.getShulker().getInt("sounds.volume", 50) / 100.0f;
                    float pitch = (float)this.configManager.getShulker().getDouble("sounds.pitch", 1.0);
                    event.getPlayer().playSound(event.getPlayer().getLocation(), lockedSound, volume, pitch);
                    shulkerLocation.getWorld().playSound(shulkerLocation, lockedSound, volume * 0.5f, pitch * 0.8f);
                }
                catch (IllegalArgumentException var27) {
                    event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.BLOCK_BARREL_CLOSE, 0.5f, 1.0f);
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onLoot(LootGenerateEvent e) {
        int result = this.random.nextInt(100);
        if (result < this.configManager.getItemManager().getSpawnChance()) {
            e.getLoot().add(this.configManager.getItemManager().getKey());
            Entity entity = e.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                String rawMsg = this.configManager.getMessages().getString("messages.key-found");
                String finalMsg = MessageUtil.colorize(rawMsg.replace("{player}", player.getName()));
                Bukkit.broadcastMessage((String)finalMsg);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        this.pistonUtil(e.getBlocks(), (BlockPistonEvent)e);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        this.pistonUtil(e.getBlocks(), (BlockPistonEvent)e);
    }

    private void pistonUtil(List<Block> pushedBlocks, BlockPistonEvent e) {
        for (Block b : pushedBlocks) {
            if (!this.shulkerManager.isShulker(b)) continue;
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (event.getInventory().getMatrix() == null) {
            return;
        }
        for (ItemStack item : event.getInventory().getMatrix()) {
            if (item == null || item.getType() == Material.AIR || !this.itemChecker.isKeyItem(item) && !this.itemChecker.isCompassItem(item)) continue;
            event.getInventory().setResult(new ItemStack(Material.AIR));
            break;
        }
    }

    @EventHandler
    public void on(BlockBreakEvent e) {
        if (this.shulkerManager.isShulker(e.getBlock())) {
            ConfigurationSection locsSection = this.shulkers.getConfig().getConfigurationSection("locs");
            if (locsSection == null) {
                return;
            }
            for (String itemId : locsSection.getKeys(false)) {
                ConfigurationSection shulker = locsSection.getConfigurationSection(itemId);
                Location shulkerLocation = shulker.getLocation("location");
                if (e.getBlock().getLocation().getBlockX() != shulkerLocation.getBlockX() || e.getBlock().getLocation().getBlockY() != shulkerLocation.getBlockY() || e.getBlock().getLocation().getBlockZ() != shulkerLocation.getBlockZ() || !e.getBlock().getLocation().getWorld().getName().equals(shulkerLocation.getWorld().getName())) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onKeyUsage(PlayerInteractEvent event) {
        ItemStack itemInHand = event.getItem();
        if (itemInHand == null || itemInHand.getType() == Material.AIR || this.itemChecker.isKeyItem(itemInHand)) {
            // empty if block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCompassUse(PlayerInteractEvent event) {
        ItemStack item;
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && (item = event.getItem()) != null && item.getType() != Material.AIR && this.itemChecker.isCompassItem(item)) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            Location randomDangLocation = this.getRandomDangLocation();
            if (randomDangLocation == null) {
                String noDangsMsg = this.configManager.getMessages().getString("messages.givecompass.no_dangs");
                if (noDangsMsg != null) {
                    player.sendMessage(MessageUtil.colorize(noDangsMsg));
                }
            } else {
                String showingMsg = this.configManager.getMessages().getString("messages.givecompass.showing_location");
                if (showingMsg != null) {
                    showingMsg = showingMsg.replace("{x}", String.valueOf(randomDangLocation.getBlockX())).replace("{y}", String.valueOf(randomDangLocation.getBlockY())).replace("{z}", String.valueOf(randomDangLocation.getBlockZ()));
                    player.sendMessage(MessageUtil.colorize(showingMsg));
                }
                player.playSound(player.getLocation(), Sound.ITEM_LODESTONE_COMPASS_LOCK, 1.0f, 1.0f);
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                } else {
                    player.getInventory().setItem(event.getHand(), (ItemStack)null);
                }
            }
        }
    }

    private void checkAndScheduleCleanup(Location loc) {
        RegionContainer container;
        RegionManager manager;
        if (this.configManager.getAuto().getBoolean("auto.enabled") && (manager = (container = WorldGuard.getInstance().getPlatform().getRegionContainer()).get(BukkitAdapter.adapt((World)loc.getWorld()))) != null) {
            ApplicableRegionSet set = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)loc));
            String prefix = this.configManager.getRegion().getString("region.name_format", "dang_").replace("{id}", "");
            set.getRegions().stream().filter(r -> r.getId().startsWith(prefix)).findFirst().ifPresent(region -> {
                boolean anyLeft;
                ConfigurationSection locs = this.shulkers.getConfig().getConfigurationSection("locs");
                if (locs != null && !(anyLeft = locs.getKeys(false).stream().anyMatch(key -> {
                    ConfigurationSection s = locs.getConfigurationSection(key);
                    Location sLoc = s.getLocation("location");
                    return sLoc != null && sLoc.getWorld().getName().equals(loc.getWorld().getName()) && region.contains(BukkitAdapter.asBlockVector((Location)sLoc)) && !s.getBoolean("opened");
                }))) {
                    this.undoUtil.scheduleAutoUndoWithActionBar(region.getId(), loc.getWorld(), (ProtectedRegion)region);
                }
            });
        }
    }

    private Location getRandomDangLocation() {
        ConfigurationSection locsSection = this.shulkers.getConfig().getConfigurationSection("locs");
        if (locsSection != null && !locsSection.getKeys(false).isEmpty()) {
            ArrayList dangIds = new ArrayList(locsSection.getKeys(false));
            if (dangIds.isEmpty()) {
                return null;
            }
            String randomDangId = (String)dangIds.get(this.random.nextInt(dangIds.size()));
            ConfigurationSection dangSection = locsSection.getConfigurationSection(randomDangId);
            return dangSection != null ? dangSection.getLocation("location") : null;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (this.itemChecker.isKeyItem(item)) {
            event.setCancelled(true);
        }
    }

    public EventManager(Storage shulkers, ConfigManager configManager, ShulkerManager shulkerManager, ItemChecker itemChecker, UndoUtil undoUtil) {
        this.shulkers = shulkers;
        this.configManager = configManager;
        this.shulkerManager = shulkerManager;
        this.itemChecker = itemChecker;
        this.undoUtil = undoUtil;
    }
}

