/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import ru.truhot.rdang.data.DangData;

public class DangManager {
    private final List<DangData> dangs = new ArrayList<DangData>();
    private final Map<String, DangData> dangMap = new HashMap<String, DangData>();

    public void load(ConfigurationSection section) {
        this.dangs.clear();
        this.dangMap.clear();
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection dangSection = section.getConfigurationSection(key);
            if (dangSection == null) continue;
            String fileName = dangSection.getString("fileName");
            String world = dangSection.getString("world");
            String biomeString = dangSection.getString("biome", "DESERT");
            if (fileName == null || world == null) continue;
            List<Biome> biomes = this.parseBiomes(biomeString);
            DangData dangData = new DangData(fileName, world, biomes);
            this.dangs.add(dangData);
            this.dangMap.put(key, dangData);
        }
    }

    private List<Biome> parseBiomes(String biomeString) {
        String[] biomeNames;
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        if (biomeString == null || biomeString.isEmpty()) {
            return List.of(Biome.DESERT);
        }
        for (String biomeName : biomeNames = biomeString.split(";")) {
            Biome biome;
            String trimmedName = biomeName.trim();
            if (trimmedName.isEmpty() || (biome = this.getBiomeFromString(trimmedName)) == null) continue;
            biomes.add(biome);
        }
        return biomes.isEmpty() ? List.of(Biome.DESERT) : biomes;
    }

    private Biome getBiomeFromString(String biomeName) {
        if (biomeName == null || biomeName.isEmpty()) {
            return null;
        }
        try {
            return Biome.valueOf((String)biomeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            String formattedName = biomeName.toUpperCase().replace(' ', '_');
            try {
                return Biome.valueOf((String)formattedName);
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }
    }

    public DangData getDangById(String id) {
        return this.dangMap.get(id);
    }

    public List<DangData> getDangsForWorld(String worldName) {
        ArrayList<DangData> result = new ArrayList<DangData>();
        for (DangData dang : this.dangs) {
            if (!dang.getWorld().equalsIgnoreCase(worldName)) continue;
            result.add(dang);
        }
        return result;
    }

    public List<DangData> getDangs() {
        return this.dangs;
    }

    public Map<String, DangData> getDangMap() {
        return this.dangMap;
    }
}

