/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.\u0441ore;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.\u0441ore.managers.EventManager;
import ru.truhot.rdang.\u0441ore.managers.ItemChecker;
import ru.truhot.rdang.\u0441ore.managers.LootManager;
import ru.truhot.rdang.\u0441ore.managers.ShulkerManager;

public class MainCore
implements Listener {
    private final Storage items;
    private final Storage shulkers;
    private final ConfigManager configManager;
    private final LootManager lootManager;
    private final ShulkerManager shulkerManager;
    private final ItemChecker itemChecker;
    private final EventManager eventHandler;

    public void fillInventoryWithRandomLoot(Inventory inventory) {
        this.lootManager.fillInventoryWithRandomLoot(inventory);
    }

    public void addShulker(Location location) {
        this.shulkerManager.addShulker(location);
    }

    public void addShulkerConfig(String id, Location location, boolean opened) {
        this.shulkerManager.addShulkerConfig(id, location, opened);
    }

    public void addItem(String id, ItemStack item, int chance, int minAmount, int maxAmount) {
        this.lootManager.addItem(id, item, chance, minAmount, maxAmount);
    }

    public boolean isShulker(Block placedBlock) {
        return this.shulkerManager.isShulker(placedBlock);
    }

    public boolean isValidKey(ItemStack item) {
        return this.itemChecker.isValidKey(item);
    }

    public boolean isKeyItem(ItemStack item) {
        return this.itemChecker.isKeyItem(item);
    }

    public boolean isCompassItem(ItemStack item) {
        return this.itemChecker.isCompassItem(item);
    }

    public int getRandomNumber(int min, int max) {
        return this.lootManager.getRandomNumber(min, max);
    }

    public Storage getItems() {
        return this.items;
    }

    public Storage getShulkers() {
        return this.shulkers;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LootManager getLootManager() {
        return this.lootManager;
    }

    public ShulkerManager getShulkerManager() {
        return this.shulkerManager;
    }

    public ItemChecker getItemChecker() {
        return this.itemChecker;
    }

    public EventManager getEventHandler() {
        return this.eventHandler;
    }

    public MainCore(Storage items, Storage shulkers, ConfigManager configManager, LootManager lootManager, ShulkerManager shulkerManager, ItemChecker itemChecker, EventManager eventHandler) {
        this.items = items;
        this.shulkers = shulkers;
        this.configManager = configManager;
        this.lootManager = lootManager;
        this.shulkerManager = shulkerManager;
        this.itemChecker = itemChecker;
        this.eventHandler = eventHandler;
    }
}

