/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import ru.truhot.rdang.RDang;

public class UpdateUtil {
    private final RDang plugin;
    private final String url = "https://api.github.com/repos/Truhott/RDang/releases/latest";
    private boolean updateAvailable = false;
    private String latestVersion = null;

    public UpdateUtil(RDang plugin) {
        this.plugin = plugin;
    }

    public void check() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/Truhott/RDang/releases/latest")).header("User-Agent", "Java 11 HttpClient (RDang)").GET().build();
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonParser parser = new JsonParser();
                    JsonObject jsonObject = parser.parse(response.body()).getAsJsonObject();
                    this.latestVersion = jsonObject.has("tag_name") ? jsonObject.get("tag_name").getAsString().replace("v", "") : "Unknown";
                    String currentVersion = this.plugin.getDescription().getVersion().replace("v", "");
                    this.updateAvailable = this.needsUpdate(currentVersion, this.latestVersion);
                    if (this.updateAvailable) {
                        this.plugin.getLogger().warning("========================================");
                        this.plugin.getLogger().warning("Rdang | \u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435!");
                        this.plugin.getLogger().warning("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + currentVersion);
                        this.plugin.getLogger().warning("\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + this.latestVersion);
                        this.plugin.getLogger().warning("========================================");
                    } else {
                        this.plugin.getLogger().info("| \u0410\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + currentVersion);
                    }
                } else {
                    this.plugin.getLogger().warning("| \u041e\u0448\u0438\u0431\u043a\u0430 HTTP: " + response.statusCode());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("| \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + e.getMessage());
            }
        });
    }

    private boolean needsUpdate(String current, String latest) {
        try {
            String[] cP = current.split("\\.");
            String[] lP = latest.split("\\.");
            int length = Math.max(cP.length, lP.length);
            for (int i = 0; i < length; ++i) {
                int lV;
                int cV = i < cP.length ? Integer.parseInt(cP[i]) : 0;
                int n = lV = i < lP.length ? Integer.parseInt(lP[i]) : 0;
                if (cV < lV) {
                    return true;
                }
                if (cV <= lV) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

