/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.util;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.TimeUtil;

public class UndoUtil {
    private final ConfigManager configManager;
    private final Storage shulkers;
    private final Storage blockStorage;
    private final RDang plugin;

    public UndoUtil(ConfigManager configManager, Storage shulkers, Storage blockStorage, RDang plugin) {
        this.configManager = configManager;
        this.shulkers = shulkers;
        this.blockStorage = blockStorage;
        this.plugin = plugin;
    }

    public void saveDungeonData(String regionName, World world, BlockVector3 minPoint) {
        String path = "history." + regionName;
        this.blockStorage.getConfig().set(path + ".world", (Object)world.getName());
        this.blockStorage.getConfig().set(path + ".x", (Object)minPoint.getX());
        this.blockStorage.getConfig().set(path + ".y", (Object)minPoint.getY());
        this.blockStorage.getConfig().set(path + ".z", (Object)minPoint.getZ());
        this.blockStorage.save();
    }

    public UndoResult performUndo(String regionName) {
        String path = "history." + regionName;
        ConfigurationSection data = this.blockStorage.getConfig().getConfigurationSection(path);
        if (data == null) {
            return new UndoResult(0, "Unknown", false);
        }
        String worldName = data.getString("world");
        World world = Bukkit.getWorld((String)Objects.requireNonNull(worldName));
        if (world == null) {
            return new UndoResult(0, worldName, false);
        }
        BlockVector3 minPoint = BlockVector3.at((int)data.getInt("x"), (int)data.getInt("y"), (int)data.getInt("z"));
        this.restoreLandscapeLayered(regionName, world, minPoint);
        int removedCount = 0;
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager != null && manager.hasRegion(regionName)) {
            ProtectedRegion region = manager.getRegion(regionName);
            removedCount = this.removeShulkersInRegion(this.getRegionCenter(region, world), world);
            manager.removeRegion(regionName);
        }
        this.blockStorage.getConfig().set(path, null);
        this.blockStorage.save();
        if (removedCount > 0) {
            this.shulkers.save();
        }
        return new UndoResult(removedCount, worldName, true);
    }

    private void restoreLandscapeLayered(String regionName, final World world, final BlockVector3 minPoint) {
        final File backupFile = new File(this.plugin.getDataFolder(), "backups/" + regionName + ".schem");
        if (!backupFile.exists()) {
            return;
        }
        final ClipboardFormat format = ClipboardFormats.findByFile((File)backupFile);
        if (format == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (FileInputStream fis = new FileInputStream(backupFile);
                     ClipboardReader reader = format.getReader((InputStream)fis);){
                    final Clipboard clipboard = reader.read();
                    final BlockVector3 dimensions = clipboard.getDimensions();
                    final BlockVector3 clipMin = clipboard.getMinimumPoint();
                    final BlockVector3 offset = minPoint.subtract(clipMin);
                    new BukkitRunnable(){
                        int currentY = 0;

                        public void run() {
                            if (this.currentY >= dimensions.getY()) {
                                if (backupFile.exists()) {
                                    backupFile.delete();
                                }
                                this.cancel();
                                return;
                            }
                            try (EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)world));){
                                BlockVector3 layerMin = clipMin.add(0, this.currentY, 0);
                                BlockVector3 layerMax = BlockVector3.at((int)clipboard.getMaximumPoint().getX(), (int)(clipMin.getY() + this.currentY), (int)clipboard.getMaximumPoint().getZ());
                                CuboidRegion layerRegion = new CuboidRegion(layerMin, layerMax);
                                ForwardExtentCopy copy = new ForwardExtentCopy((Extent)clipboard, (Region)layerRegion, (Extent)editSession, layerMin.add(offset));
                                copy.setCopyingEntities(false);
                                Operations.complete((Operation)copy);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++this.currentY;
                        }
                    }.runTaskTimer((Plugin)UndoUtil.this.plugin, 1L, 1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void scheduleAutoUndoWithActionBar(final String regionName, final World world, final ProtectedRegion region) {
        String timeStr = this.configManager.getAuto().getString("auto.time");
        final long seconds = TimeUtil.parseTimeString(timeStr);
        new BukkitRunnable(){
            private long timeLeft;
            {
                this.timeLeft = seconds;
            }

            public void run() {
                if (this.timeLeft <= 0L) {
                    UndoUtil.this.performUndo(regionName);
                    this.cancel();
                    return;
                }
                String rawMsg = UndoUtil.this.configManager.getMessages().getString("messages.actionbar-timer");
                String formattedTime = TimeUtil.formatTime(this.timeLeft);
                String finalMsg = MessageUtil.colorize(rawMsg.replace("{time}", formattedTime));
                for (Player player : world.getPlayers()) {
                    boolean isInRegion = region.contains(BukkitAdapter.asBlockVector((Location)player.getLocation()));
                    if (!isInRegion) continue;
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(finalMsg));
                }
                --this.timeLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private int removeShulkersInRegion(Location center, World world) {
        ConfigurationSection locs = this.shulkers.getConfig().getConfigurationSection("locs");
        if (locs == null) {
            return 0;
        }
        int radiusX = this.configManager.getRegion().getInt("region.size.x", 12);
        int radiusZ = this.configManager.getRegion().getInt("region.size.z", 12);
        return (int)locs.getKeys(false).stream().filter(key -> {
            Location loc = locs.getLocation(key + ".location");
            return loc != null && loc.getWorld().getName().equals(world.getName()) && Math.abs(loc.getBlockX() - center.getBlockX()) <= radiusX && Math.abs(loc.getBlockZ() - center.getBlockZ()) <= radiusZ;
        }).peek(key -> locs.set(key, null)).count();
    }

    private Location getRegionCenter(ProtectedRegion region, World world) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return new Location(world, (double)(min.getX() + max.getX()) / 2.0, (double)(min.getY() + max.getY()) / 2.0, (double)(min.getZ() + max.getZ()) / 2.0);
    }

    public static class UndoResult {
        public final int shulkerCount;
        public final String worldName;
        public final boolean found;

        public UndoResult(int shulkerCount, String worldName, boolean found) {
            this.shulkerCount = shulkerCount;
            this.worldName = worldName;
            this.found = found;
        }
    }
}

