/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    public static long parseTimeString(String timeStr) {
        if (timeStr == null || timeStr.isEmpty()) {
            return 10L;
        }
        long totalSeconds = 0L;
        Pattern pattern = Pattern.compile("(\\d+)([dhms])");
        Matcher matcher = pattern.matcher(timeStr.toLowerCase());
        while (matcher.find()) {
            String unit;
            long value = Long.parseLong(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "d": {
                    totalSeconds += value * 86400L;
                    break;
                }
                case "h": {
                    totalSeconds += value * 3600L;
                    break;
                }
                case "m": {
                    totalSeconds += value * 60L;
                    break;
                }
                case "s": {
                    totalSeconds += value;
                }
            }
        }
        return totalSeconds > 0L ? totalSeconds : 10L;
    }

    public static String formatTime(long seconds) {
        if (seconds < 60L) {
            return seconds + "\u0441";
        }
        long m = seconds / 60L;
        long s = seconds % 60L;
        if (m < 60L) {
            return m + "\u043c " + s + "\u0441";
        }
        long h = m / 60L;
        return h + "\u0447 " + (m %= 60L) + "\u043c " + s + "\u0441";
    }
}

