/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.schem;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;

public class SchemAction {
    private final RDang plugin;
    private final ConfigManager configManager;

    public void spawnSchemLayered(final @NotNull Location location, @NotNull String fileName, final Runnable onComplete) {
        File schemFile;
        ClipboardFormat format;
        if (location == null) {
            SchemAction.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            SchemAction.$$$reportNull$$$0(1);
        }
        if ((format = ClipboardFormats.findByFile((File)(schemFile = new File(this.plugin.getDataFolder() + "/schem/" + fileName)))) == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (FileInputStream fis = new FileInputStream(schemFile);
                     ClipboardReader reader = format.getReader((InputStream)fis);){
                    final Clipboard clipboard = reader.read();
                    final BlockVector3 clipMin = clipboard.getMinimumPoint();
                    final BlockVector3 dimensions = clipboard.getDimensions();
                    final boolean copyEntities = SchemAction.this.configManager.getSchem().getBoolean("entities", true);
                    final boolean copyBiomes = SchemAction.this.configManager.getSchem().getBoolean("biomes", false);
                    ConfigurationSection offsetSection = SchemAction.this.configManager.getSchem().getConfigurationSection("schem-offset");
                    double offX = offsetSection != null ? offsetSection.getDouble("x") : 0.0;
                    double offY = offsetSection != null ? offsetSection.getDouble("y") : 0.0;
                    double offZ = offsetSection != null ? offsetSection.getDouble("z") : 0.0;
                    BlockVector3 targetPos = BlockVector3.at((double)(location.getX() + offX), (double)(location.getY() + offY), (double)(location.getZ() + offZ));
                    final BlockVector3 offset = targetPos.subtract(clipMin);
                    new BukkitRunnable(){
                        int currentY = 0;

                        public void run() {
                            if (this.currentY >= dimensions.getY()) {
                                if (onComplete != null) {
                                    onComplete.run();
                                }
                                this.cancel();
                                return;
                            }
                            try (EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)location.getWorld()));){
                                BlockVector3 layerMin = clipMin.add(0, this.currentY, 0);
                                BlockVector3 layerMax = BlockVector3.at((int)clipboard.getMaximumPoint().getX(), (int)(clipMin.getY() + this.currentY), (int)clipboard.getMaximumPoint().getZ());
                                CuboidRegion layerRegion = new CuboidRegion(layerMin, layerMax);
                                ForwardExtentCopy copy = new ForwardExtentCopy((Extent)clipboard, (Region)layerRegion, (Extent)editSession, layerMin.add(offset));
                                copy.setCopyingEntities(copyEntities);
                                copy.setCopyingBiomes(copyBiomes);
                                Operations.complete((Operation)copy);
                            }
                            catch (WorldEditException e) {
                                e.printStackTrace();
                                this.cancel();
                            }
                            ++this.currentY;
                        }
                    }.runTaskTimer((Plugin)SchemAction.this.plugin, 1L, 1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void spawnSchem(@NotNull Location location, @NotNull String fileName) {
        File schemFile;
        ClipboardFormat format;
        if (location == null) {
            SchemAction.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            SchemAction.$$$reportNull$$$0(3);
        }
        if ((format = ClipboardFormats.findByFile((File)(schemFile = new File(this.plugin.getDataFolder() + "/schem/" + fileName)))) == null) {
            return;
        }
        try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(schemFile));){
            Clipboard clipboard = reader.read();
            boolean ignoreAirBlocks = this.configManager.getSchem().getBoolean("ignore-air-blocks", true);
            int rotation = this.configManager.getSchem().getInt("rotation", 0);
            boolean mirror = this.configManager.getSchem().getBoolean("mirror", false);
            boolean copyEntities = this.configManager.getSchem().getBoolean("entities", true);
            boolean copyBiomes = this.configManager.getSchem().getBoolean("biomes", false);
            ConfigurationSection offsetSection = this.configManager.getSchem().getConfigurationSection("schem-offset");
            double offsetX = offsetSection != null ? offsetSection.getDouble("x") : 0.0;
            double offsetY = offsetSection != null ? offsetSection.getDouble("y") : 0.0;
            double offsetZ = offsetSection != null ? offsetSection.getDouble("z") : 0.0;
            Location adjustedLocation = location.clone().add(offsetX, offsetY, offsetZ);
            BlockVector3 coordinates = BlockVector3.at((double)adjustedLocation.getX(), (double)adjustedLocation.getY(), (double)adjustedLocation.getZ());
            try (EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)adjustedLocation.getWorld()));){
                ClipboardHolder clipboardHolder = new ClipboardHolder(clipboard);
                if (rotation != 0 || mirror) {
                    AffineTransform transform = new AffineTransform();
                    if (rotation != 0) {
                        transform = transform.rotateY((double)rotation);
                    }
                    if (mirror) {
                        transform = transform.scale(-1.0, 1.0, 1.0);
                    }
                    clipboardHolder.setTransform((Transform)transform);
                }
                Operation operation = clipboardHolder.createPaste((Extent)editSession).to(coordinates).ignoreAirBlocks(ignoreAirBlocks).copyEntities(copyEntities).copyBiomes(copyBiomes).build();
                Operations.complete((Operation)operation);
            }
        }
        catch (WorldEditException | IOException exception) {
            exception.printStackTrace();
        }
    }

    public void createBackup(@NotNull Location location, String regionName) {
        if (location == null) {
            SchemAction.$$$reportNull$$$0(4);
        }
        int radiusX = this.configManager.getRegion().getInt("region.size.x", 12);
        int radiusZ = this.configManager.getRegion().getInt("region.size.z", 12);
        int minY = this.configManager.getRegion().getInt("region.height.min", 0);
        int maxY = this.configManager.getRegion().getInt("region.height.max", 255);
        BlockVector3 min = BlockVector3.at((int)(location.getBlockX() - radiusX), (int)minY, (int)(location.getBlockZ() - radiusZ));
        BlockVector3 max = BlockVector3.at((int)(location.getBlockX() + radiusX), (int)maxY, (int)(location.getBlockZ() + radiusZ));
        CuboidRegion region = new CuboidRegion(BukkitAdapter.adapt((World)location.getWorld()), min, max);
        File backupFile = new File(this.plugin.getDataFolder() + "/backups/" + regionName + ".schem");
        if (!backupFile.getParentFile().exists()) {
            backupFile.getParentFile().mkdirs();
        }
        BuiltInClipboardFormat format = BuiltInClipboardFormat.SPONGE_SCHEMATIC;
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)location.getWorld()));){
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
            clipboard.setOrigin(region.getMinimumPoint());
            ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, region.getMinimumPoint());
            Operations.complete((Operation)copy);
            try (ClipboardWriter writer = format.getWriter((OutputStream)new FileOutputStream(backupFile));){
                writer.write((Clipboard)clipboard);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SchemAction(RDang plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "ru/truhot/rdang/schem/SchemAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "spawnSchemLayered";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "spawnSchem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBackup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

