/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.menu;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.menu.AbstractMenu;
import ru.truhot.rdang.menu.DungeonListMenu;
import ru.truhot.rdang.storage.Storage;

public class MenuManager
implements Listener {
    private final ConfigManager configManager;
    private final Storage shulkers;
    private final Storage blockStorage;
    private final RDang plugin;
    private final Map<String, AbstractMenu> menus = new HashMap<String, AbstractMenu>();
    private DungeonListMenu dungeonListMenu;

    public MenuManager(ConfigManager configManager, Storage shulkers, Storage blockStorage, RDang plugin) {
        this.configManager = configManager;
        this.shulkers = shulkers;
        this.blockStorage = blockStorage;
        this.plugin = plugin;
        this.registerMenus();
    }

    private void registerMenus() {
        this.dungeonListMenu = new DungeonListMenu(this.configManager, this.shulkers, this.blockStorage, this.plugin);
        this.menus.put("dungeon_list", this.dungeonListMenu);
    }

    public void openDungeonList(Player player, int page) {
        if (this.dungeonListMenu != null) {
            this.dungeonListMenu.openMenu(player, page);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        for (AbstractMenu menu : this.menus.values()) {
            menu.onClick(player, e);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        for (AbstractMenu menu : this.menus.values()) {
            menu.close(player, e);
        }
    }
}

