/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.menu;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.menu.AbstractMenu;
import ru.truhot.rdang.menu.MenuHolder;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.HeadUtil;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.TeleportUtil;
import ru.truhot.rdang.util.UndoUtil;

public class DungeonListMenu
extends AbstractMenu {
    private static final int ITEMS_PER_PAGE = 45;
    private static final int INVENTORY_SIZE = 54;
    private static final int[] BOTTOM_BAR_SLOTS = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int NEXT_PAGE_SLOT = 50;
    private static final int PREV_PAGE_SLOT = 48;
    private final TeleportUtil teleportUtil;
    private final String regionNameFormat;
    private final Storage shulkers;
    private final Storage blockStorage;

    public DungeonListMenu(ConfigManager configManager, Storage shulkers, Storage blockStorage, RDang plugin) {
        super(configManager, plugin);
        this.shulkers = shulkers;
        this.blockStorage = blockStorage;
        this.teleportUtil = new TeleportUtil(configManager);
        this.regionNameFormat = configManager.getRegion().getString("region.name_format", "dang_{id}");
    }

    @Override
    public void openMenu(Player player, int page) {
        List<String> regionIds = this.loadRegionIdsForPage(page);
        if (regionIds.isEmpty() && page == 0) {
            String message = this.configManager.getMessages().getString("messages.list.no-dungeons");
            player.sendMessage(MessageUtil.colorize(message));
            return;
        }
        this.open(player, page);
    }

    @Override
    protected String getMenuId() {
        return "dungeon_list";
    }

    @Override
    protected Inventory createInventory(Player player, int page) {
        List<String> allRegionIds = this.getAllRegionIds();
        int totalRegions = allRegionIds.size();
        int maxPages = Math.max(1, (int)Math.ceil((double)totalRegions / 45.0));
        page = Math.max(0, Math.min(page, maxPages - 1));
        List<String> pageRegionIds = this.getPageRegionIds(allRegionIds, page);
        String title = MessageUtil.colorize("\u00a7f\u0421\u043f\u0438\u0441\u043e\u043a \u0414\u0430\u043d\u0436\u0435\u0439 &7(" + (page + 1) + "/" + maxPages + ")");
        MenuHolder holder = new MenuHolder(this.getMenuId(), page);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)54, (String)title);
        holder.setInventory(inventory);
        this.addDungeonItems(inventory, pageRegionIds);
        this.fillBottomBar(inventory, page, maxPages);
        return inventory;
    }

    @Override
    protected void handleMenuClick(Player player, InventoryClickEvent e) {
        String name;
        ItemMeta meta;
        e.setCancelled(true);
        int slot = e.getRawSlot();
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR || slot >= 45) {
            return;
        }
        if (clickedItem.getType() == Material.PLAYER_HEAD && (meta = clickedItem.getItemMeta()) != null && ((name = meta.getDisplayName()).contains("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f") || name.contains("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f"))) {
            MenuHolder holder = (MenuHolder)e.getInventory().getHolder();
            int newPage = holder.getPage() + (name.contains("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f") ? 1 : -1);
            this.openMenu(player, newPage);
            return;
        }
        if (this.isDungeonItem(clickedItem)) {
            MenuHolder holder = (MenuHolder)e.getInventory().getHolder();
            List<String> currentIds = this.loadRegionIdsForPage(holder.getPage());
            if (slot >= currentIds.size()) {
                return;
            }
            String regionId = currentIds.get(slot);
            String dungeonDisplayId = String.valueOf(this.extractRegionNumber(regionId));
            if (e.isRightClick()) {
                player.closeInventory();
                this.teleportUtil.teleportToDungeon(player, regionId);
            } else if (e.isLeftClick()) {
                UndoUtil undoUtil = new UndoUtil(this.configManager, this.shulkers, this.blockStorage, this.plugin);
                UndoUtil.UndoResult result = undoUtil.performUndo(regionId);
                if (result.found) {
                    player.sendMessage(MessageUtil.colorize(this.configManager.getMessages().getString("messages.undo.region-deleted").replace("{id}", dungeonDisplayId).replace("{region}", regionId).replace("{world}", result.worldName)));
                    player.sendMessage(MessageUtil.colorize(this.configManager.getMessages().getString("messages.undo.shulkers-deleted").replace("{shulker}", String.valueOf(result.shulkerCount))));
                    this.openMenu(player, holder.getPage());
                } else {
                    player.sendMessage(MessageUtil.colorize(this.configManager.getMessages().getString("messages.undo.region-not-found").replace("{id}", dungeonDisplayId).replace("{region}", regionId)));
                }
            }
        }
    }

    private List<String> getAllRegionIds() {
        ArrayList<String> regionIds = new ArrayList<String>();
        try {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            if (container == null) {
                return regionIds;
            }
            String format = this.configManager.getRegion().getString("region.name_format");
            String prefix = format.contains("{id}") ? format.split("\\{id\\}")[0] : format;
            for (World world : Bukkit.getWorlds()) {
                RegionManager regionManager = container.get(BukkitAdapter.adapt((World)world));
                if (regionManager == null) continue;
                for (String regionName : regionManager.getRegions().keySet()) {
                    if (!regionName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    regionIds.add(regionName);
                }
            }
            regionIds.sort((r1, r2) -> Integer.compare(this.extractRegionNumber((String)r1), this.extractRegionNumber((String)r2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return regionIds;
    }

    private int extractRegionNumber(String regionId) {
        try {
            String numberOnly = regionId.replaceAll("[^0-9]", "");
            return numberOnly.isEmpty() ? 0 : Integer.parseInt(numberOnly);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String extractDungeonNumber(String displayName) {
        try {
            String cleanName = displayName.replaceAll("\u00a7[0-9a-fk-orx]", "");
            int start = cleanName.indexOf("[") + 1;
            int end = cleanName.indexOf("]");
            return cleanName.substring(start, end).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<String> loadRegionIdsForPage(int page) {
        List<String> allRegionIds = this.getAllRegionIds();
        int start = page * 45;
        int end = Math.min(start + 45, allRegionIds.size());
        return start >= allRegionIds.size() ? new ArrayList() : allRegionIds.subList(start, end);
    }

    private List<String> getPageRegionIds(List<String> allRegionIds, int page) {
        int start = page * 45;
        int end = Math.min(start + 45, allRegionIds.size());
        return start >= allRegionIds.size() ? new ArrayList() : allRegionIds.subList(start, end);
    }

    private void addDungeonItems(Inventory inventory, List<String> regionIds) {
        for (int i = 0; i < regionIds.size() && i < 45; ++i) {
            inventory.setItem(i, this.createDungeonItem(regionIds.get(i)));
        }
    }

    private ItemStack createDungeonItem(String regionId) {
        ItemStack item;
        ItemMeta meta;
        int dungeonNumber = this.extractRegionNumber(regionId);
        World regionWorld = this.getWorldForRegion(regionId);
        Material material = Material.DIRT;
        if (regionWorld != null) {
            String worldName = regionWorld.getName().toLowerCase();
            if (worldName.contains("nether")) {
                material = Material.NETHERRACK;
            } else if (worldName.contains("end")) {
                material = Material.END_STONE;
            }
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            meta.setDisplayName(MessageUtil.colorize("&f\u0414\u0430\u043d\u0436 &8[" + dungeonNumber + "]"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(MessageUtil.colorize(" &f\u041c\u0438\u0440: &#557c93" + (regionWorld != null ? regionWorld.getName() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d")));
            lore.add(MessageUtil.colorize(" &f\u041a\u043e\u0440\u0434\u044b: &#FEF06A" + this.getCoordinates(regionWorld, regionId)));
            lore.add("");
            lore.add(MessageUtil.colorize(" &f\u041f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 &#557c93\u041f\u041a\u041c&f \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442"));
            lore.add(MessageUtil.colorize(" &f\u041f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 &#FE6A6A\u041b\u041a\u041c&f \u0443\u0434\u0430\u043b\u044f\u0435\u0442"));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void fillBottomBar(Inventory inventory, int currentPage, int maxPages) {
        ItemStack blackPane = this.createPane(Material.BLACK_STAINED_GLASS_PANE, " ");
        for (int slot : BOTTOM_BAR_SLOTS) {
            inventory.setItem(slot, blackPane);
        }
        inventory.setItem(49, this.createInfoItem());
        if (currentPage > 0) {
            inventory.setItem(48, this.createPreviousPageItem());
        }
        if (currentPage < maxPages - 1) {
            inventory.setItem(50, this.createNextPageItem());
        }
    }

    private ItemStack createPreviousPageItem() {
        ItemStack head = HeadUtil.createSkullFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzYyNTkwMmIzODllZDZjMTQ3NTc0ZTQyMmRhOGY4ZjM2MWM4ZWI1N2U3NjMxNjc2YTcyNzc3ZTdiMWQifX19");
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtil.colorize("\u00a7f[ \u00a77\u2190 \u00a7f] \u00a76\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430"));
        }
        head.setItemMeta(meta);
        return head;
    }

    private ItemStack createNextPageItem() {
        ItemStack head = HeadUtil.createSkullFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDRiZThhZWVjMTE4NDk2OTdhZGM2ZmQxZjE4OWIxNjY0MmRmZjE5ZjI5NTVjMDVkZWFiYTY4YzlkZmYxYmUifX19");
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtil.colorize("\u00a76\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u00a7f[ \u00a77\u2192 \u00a7f]"));
        }
        head.setItemMeta(meta);
        return head;
    }

    private ItemStack createInfoItem() {
        ItemStack head = HeadUtil.createSkullFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTM1OWQ5MTI3NzI0MmZjMDFjMzA5YWNjYjg3YjUzM2YxOTI5YmUxNzZlY2JhMmNkZTYzYmY2MzVlMDVlNjk5YiJ9fX0=");
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtil.colorize("\u00a77[&#FEF06A\u20aa\u00a77] \u00a7f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f"));
            meta.setLore(List.of("", MessageUtil.colorize(" &f\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0434\u0430\u043d\u0436\u0435\u0439"), ""));
            head.setItemMeta(meta);
        }
        return head;
    }

    private ItemStack createPane(Material material, String name) {
        ItemStack pane = new ItemStack(material);
        ItemMeta meta = pane.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            pane.setItemMeta(meta);
        }
        return pane;
    }

    private World getWorldForRegion(String regionId) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        for (World world : Bukkit.getWorlds()) {
            RegionManager wgManager = container.get(BukkitAdapter.adapt((World)world));
            if (wgManager == null || !wgManager.hasRegion(regionId)) continue;
            return world;
        }
        return null;
    }

    private String getCoordinates(World world, String regionId) {
        if (world == null) {
            return "\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e";
        }
        try {
            RegionManager wgManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
            ProtectedRegion region = wgManager.getRegion(regionId);
            BlockVector3 min = region.getMinimumPoint();
            BlockVector3 max = region.getMaximumPoint();
            return String.format("X: %d Y: %d Z: %d", (min.getBlockX() + max.getBlockX()) / 2, (min.getBlockY() + max.getBlockY()) / 2, (min.getBlockZ() + max.getBlockZ()) / 2);
        }
        catch (Exception e) {
            return "\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e";
        }
    }

    private boolean isDungeonItem(ItemStack item) {
        Material type = item.getType();
        return type == Material.DIRT || type == Material.NETHERRACK || type == Material.END_STONE;
    }
}

