/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.menu;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.menu.MenuHolder;
import ru.truhot.rdang.util.MessageUtil;

public abstract class AbstractMenu {
    protected final ConfigManager configManager;
    protected final RDang plugin;
    protected final Map<UUID, Inventory> playerInventories = new HashMap<UUID, Inventory>();

    public AbstractMenu(ConfigManager configManager, RDang plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
    }

    public abstract void openMenu(Player var1, int var2);

    protected abstract String getMenuId();

    protected abstract Inventory createInventory(Player var1, int var2);

    protected abstract void handleMenuClick(Player var1, InventoryClickEvent var2);

    public void open(Player player, int page) {
        Inventory inventory = this.createInventory(player, page);
        if (inventory == null) {
            player.sendMessage(MessageUtil.colorize("&c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043c\u0435\u043d\u044e!"));
            return;
        }
        player.openInventory(inventory);
        this.playerInventories.put(player.getUniqueId(), inventory);
    }

    public void close(Player player, InventoryCloseEvent e) {
        this.playerInventories.remove(player.getUniqueId());
    }

    public void onClick(Player player, InventoryClickEvent e) {
        if (!this.isValidClick(e)) {
            return;
        }
        this.handleMenuClick(player, e);
    }

    protected boolean isValidClick(InventoryClickEvent e) {
        return e.getWhoClicked() instanceof Player && e.getInventory().getHolder() instanceof MenuHolder && ((MenuHolder)e.getInventory().getHolder()).getMenuId().equals(this.getMenuId());
    }
}

