/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.dung;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import ru.truhot.rdang.addshulkers.AddShulkers;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.data.DangData;
import ru.truhot.rdang.schem.SchemAction;
import ru.truhot.rdang.util.UndoUtil;

public class DungActions {
    private final SchemAction schemAction;
    private final AddShulkers addShulkers;
    private final ConfigManager configManager;
    private final UndoUtil undoUtil;

    public void spawn(@NotNull Location loc) {
        if (loc == null) {
            DungActions.$$$reportNull$$$0(0);
        }
        World world = loc.getWorld();
        List<DangData> dangDataList = this.configManager.getDangManager().getDangs();
        int freeId = this.findFreeRegionId();
        String nameFormat = this.configManager.getRegion().getString("region.name_format", "dang_{id}");
        String regionName = nameFormat.replace("{id}", String.valueOf(freeId));
        for (int i = 0; i < 20; ++i) {
            DangData dangData = dangDataList.get(new Random().nextInt(dangDataList.size()));
            Biome currentBiome = world.getBiome(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            if (!dangData.getWorld().equals(world.getName()) || !dangData.getBiome().contains(currentBiome)) continue;
            int radiusX = this.configManager.getRegion().getInt("region.size.x", 12);
            int radiusZ = this.configManager.getRegion().getInt("region.size.z", 12);
            int minY = this.configManager.getRegion().getInt("region.height.min", 0);
            BlockVector3 minPoint = BlockVector3.at((int)(loc.getBlockX() - radiusX), (int)minY, (int)(loc.getBlockZ() - radiusZ));
            this.schemAction.createBackup(loc, regionName);
            this.undoUtil.saveDungeonData(regionName, world, minPoint);
            this.schemAction.spawnSchem(loc, dangData.getFileName());
            int maxY = this.configManager.getRegion().getInt("region.height.max", 255);
            this.addShulkers.addShulkersInRegion(loc, radiusX, radiusZ, minY, maxY);
            this.createRegionWithId(loc.getBlockX(), loc.getBlockZ(), world, freeId);
            return;
        }
    }

    public String createRegion(int x, int z, World worldBukkit) {
        int freeId = this.findFreeRegionId();
        return this.createRegionWithId(x, z, worldBukkit, freeId);
    }

    public String createRegionWithId(int x, int z, World worldBukkit, int id) {
        RegionManager regionManager;
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        int radiusX = this.configManager.getRegion().getInt("region.size.x", 12);
        int radiusZ = this.configManager.getRegion().getInt("region.size.z", 12);
        int minY = this.configManager.getRegion().getInt("region.height.min", 0);
        int maxY = this.configManager.getRegion().getInt("region.height.max", 255);
        String nameFormat = this.configManager.getRegion().getString("region.name_format", "dang_{id}");
        String regionName = nameFormat.replace("{id}", String.valueOf(id));
        if (container != null && (regionManager = container.get(BukkitAdapter.adapt((World)worldBukkit))) != null) {
            BlockVector3 minPoint = BlockVector3.at((int)(x - radiusX), (int)minY, (int)(z - radiusZ));
            BlockVector3 maxPoint = BlockVector3.at((int)(x + radiusX), (int)maxY, (int)(z + radiusZ));
            ProtectedCuboidRegion region = new ProtectedCuboidRegion(regionName, minPoint, maxPoint);
            this.setFlagsFromConfig(region);
            regionManager.addRegion((ProtectedRegion)region);
        }
        return regionName;
    }

    public int findFreeRegionId() {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            return 1;
        }
        String nameFormat = this.configManager.getRegion().getString("region.name_format", "dang_{id}");
        int id = 1;
        while (true) {
            String regionName = nameFormat.replace("{id}", String.valueOf(id));
            boolean isFree = true;
            for (World world : Bukkit.getWorlds()) {
                RegionManager regionManager = container.get(BukkitAdapter.adapt((World)world));
                if (regionManager == null || !regionManager.hasRegion(regionName)) continue;
                isFree = false;
                break;
            }
            if (isFree) {
                return id;
            }
            ++id;
        }
    }

    private void setFlagsFromConfig(ProtectedCuboidRegion region) {
        ConfigurationSection flagsSection = this.configManager.getRegion().getConfigurationSection("region.flags");
        if (flagsSection == null) {
            return;
        }
        for (String flagName : flagsSection.getKeys(false)) {
            String flagValue = flagsSection.getString(flagName, "").toLowerCase();
            if (flagValue.isEmpty()) continue;
            StateFlag.State state = flagValue.equals("allow") ? StateFlag.State.ALLOW : StateFlag.State.DENY;
            try {
                String normalizedFlagName = flagName.toUpperCase().replace("-", "_").replace(" ", "_");
                Field flagField = Flags.class.getField(normalizedFlagName);
                Flag flag = (Flag)flagField.get(null);
                if (!(flag instanceof StateFlag)) continue;
                region.setFlag((Flag)((StateFlag)flag), (Object)state);
            }
            catch (Exception exception) {}
        }
    }

    private boolean isTooCloseToOtherDang(Location loc, int minDist) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            return false;
        }
        RegionManager manager = container.get(BukkitAdapter.adapt((World)loc.getWorld()));
        if (manager == null) {
            return false;
        }
        String prefix = this.configManager.getRegion().getString("region.name_format", "dang_").replace("{id}", "");
        return manager.getRegions().values().stream().filter(r -> r.getId().startsWith(prefix)).anyMatch(r -> {
            BlockVector3 min = r.getMinimumPoint();
            BlockVector3 max = r.getMaximumPoint();
            double centerX = (double)(min.getX() + max.getX()) / 2.0;
            double centerZ = (double)(min.getZ() + max.getZ()) / 2.0;
            return Math.sqrt(Math.pow(loc.getX() - centerX, 2.0) + Math.pow(loc.getZ() - centerZ, 2.0)) < (double)minDist;
        });
    }

    private boolean isInOtherRegion(Location location) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            return false;
        }
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (manager == null) {
            return false;
        }
        String prefix = this.configManager.getRegion().getString("region.name_format", "dang_").replace("{id}", "");
        BlockVector3 vector = BukkitAdapter.asBlockVector((Location)location);
        return manager.getApplicableRegions(vector).getRegions().stream().anyMatch(r -> !r.getId().startsWith(prefix));
    }

    public DungActions(SchemAction schemAction, AddShulkers addShulkers, ConfigManager configManager, UndoUtil undoUtil) {
        this.schemAction = schemAction;
        this.addShulkers = addShulkers;
        this.configManager = configManager;
        this.undoUtil = undoUtil;
    }

    public SchemAction getSchemAction() {
        return this.schemAction;
    }

    public AddShulkers getAddShulkers() {
        return this.addShulkers;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public UndoUtil getUndoUtil() {
        return this.undoUtil;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loc", "ru/truhot/rdang/dung/DungActions", "spawn"));
    }
}

