/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.config;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.truhot.rdang.\u0441ore.managers.DangManager;
import ru.truhot.rdang.\u0441ore.managers.ItemManager;
import ru.truhot.rdang.\u0441ore.managers.MessageManager;
import ru.truhot.rdang.\u0441ore.managers.SpawnManager;
import ru.truhot.rdang.\u0441ore.managers.WorldHeightManager;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration items;
    private FileConfiguration world;
    private FileConfiguration messages;
    private FileConfiguration shulker;
    private FileConfiguration region;
    private FileConfiguration schem;
    private FileConfiguration config;
    private FileConfiguration auto;
    private final ItemManager itemManager;
    private final SpawnManager spawnManager;
    private final MessageManager messageManager;
    private final DangManager dangManager;
    private final WorldHeightManager worldHeightManager;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.itemManager = new ItemManager();
        this.spawnManager = new SpawnManager();
        this.messageManager = new MessageManager();
        this.dangManager = new DangManager();
        this.worldHeightManager = new WorldHeightManager();
        this.loadAllConfigs();
    }

    public void loadAllConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.config = this.loadConfig("config.yml", true);
        this.items = this.loadConfig("items.yml", true);
        this.world = this.loadConfig("world.yml", true);
        this.messages = this.loadConfig("messages.yml", true);
        this.shulker = this.loadConfig("shulker.yml", true);
        this.region = this.loadConfig("region.yml", true);
        this.schem = this.loadConfig("schem.yml", true);
        this.auto = this.loadConfig("auto.yml", true);
        this.itemManager.load(this.items.getConfigurationSection("items"));
        this.spawnManager.load(this.world.getConfigurationSection("spawn"), this);
        this.messageManager.load(this.messages.getConfigurationSection("messages"));
        this.dangManager.load(this.world.getConfigurationSection("dang"));
        this.worldHeightManager.load(this.schem.getConfigurationSection("world-heights"));
    }

    public void reloadAll() {
        this.loadAllConfigs();
        this.plugin.getLogger().info("\u0412\u0441\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b!");
    }

    private FileConfiguration loadConfig(String fileName, boolean saveDefault) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists() && saveDefault) {
            this.plugin.saveResource(fileName, false);
            this.plugin.getLogger().info(fileName + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public FileConfiguration getAuto() {
        return this.auto;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getShulker() {
        return this.shulker;
    }

    public FileConfiguration getRegion() {
        return this.region;
    }

    public FileConfiguration getSchem() {
        return this.schem;
    }

    public WorldHeightManager getWorldHeightManager() {
        return this.worldHeightManager;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public FileConfiguration getItems() {
        return this.items;
    }

    public FileConfiguration getWorld() {
        return this.world;
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public SpawnManager getSpawnManager() {
        return this.spawnManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public DangManager getDangManager() {
        return this.dangManager;
    }
}

