/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.UndoUtil;

public class UndoCommand
implements CommandExecutor {
    private final ConfigManager configManager;
    private final UndoUtil undoUtil;

    public UndoCommand(ConfigManager configManager, Storage shulkers, Storage blockStorage, RDang plugin) {
        this.configManager = configManager;
        this.undoUtil = new UndoUtil(configManager, shulkers, blockStorage, plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("undo.usage")));
            return true;
        }
        String dungeonId = args[1];
        String regionName = this.configManager.getRegion().getString("region.name_format", "dang_{id}").replace("{id}", dungeonId);
        UndoUtil.UndoResult result = this.undoUtil.performUndo(regionName);
        if (!result.found) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("undo.region-not-found").replace("{id}", dungeonId).replace("{region}", regionName)));
            return true;
        }
        sender.sendMessage(MessageUtil.colorize(this.getMessage("undo.region-deleted").replace("{id}", dungeonId).replace("{region}", regionName).replace("{world}", result.worldName)));
        sender.sendMessage(MessageUtil.colorize(this.getMessage("undo.shulkers-deleted").replace("{shulker}", String.valueOf(result.shulkerCount))));
        return true;
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

