/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.data.DangData;
import ru.truhot.rdang.dung.DungActions;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.\u0441ore.managers.WorldHeightManager;

public class SpawnCommand
implements CommandExecutor {
    private final DungActions dungActions;
    private final ConfigManager configManager;
    private final Random random = new Random();

    public SpawnCommand(DungActions dungActions, ConfigManager configManager) {
        this.dungActions = dungActions;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("only-player")));
            return true;
        }
        Player player = (Player)commandSender;
        if (args.length != 2) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("spawn.usage")));
            return true;
        }
        World world = player.getWorld();
        try {
            int amount = Integer.parseInt(args[1]);
            if (amount <= 0) {
                player.sendMessage(MessageUtil.colorize(this.getMessage("spawn.amount-positive")));
                return true;
            }
            int spawnedCount = 0;
            for (int i = 0; i < amount; ++i) {
                Location loc = this.findSuitableDungLocation(world);
                if (loc == null) continue;
                this.dungActions.spawn(loc);
                String spawnedMsg = this.getMessage("spawn.spawned").replace("{x}", String.valueOf(loc.getBlockX())).replace("{y}", String.valueOf(loc.getBlockY())).replace("{z}", String.valueOf(loc.getBlockZ()));
                player.sendMessage(MessageUtil.colorize(spawnedMsg));
                ++spawnedCount;
            }
            if (spawnedCount == 0) {
                player.sendMessage(MessageUtil.colorize(this.getMessage("spawn.none-spawned")));
            }
            return true;
        }
        catch (NumberFormatException e) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("spawn.invalid-number")));
            return true;
        }
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }

    private Location findSuitableDungLocation(World world) {
        int minX = this.configManager.getSpawnManager().getMinX();
        int maxX = this.configManager.getSpawnManager().getMaxX();
        int minZ = this.configManager.getSpawnManager().getMinZ();
        int maxZ = this.configManager.getSpawnManager().getMaxZ();
        for (int attempt = 0; attempt < 100; ++attempt) {
            Location loc;
            int z;
            int x = this.random.nextInt(maxX - minX + 1) + minX;
            int y = this.getSuitableHeight(world, x, z = this.random.nextInt(maxZ - minZ + 1) + minZ);
            if (y == Integer.MIN_VALUE || !this.isLocationSafe(loc = new Location(world, (double)x, (double)y, (double)z)) || !this.hasSuitableBiome(loc)) continue;
            return loc;
        }
        return null;
    }

    private int getSurfaceHeight(World world, int x, int z) {
        for (int y = world.getHighestBlockYAt(x, z); y > world.getMinHeight(); --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type)) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    private int getNetherHeight(World world, int x, int z) {
        int y;
        for (y = 32; y <= 120; ++y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type) || !this.isAirOrReplaceable(typeAbove)) continue;
            return y;
        }
        y = world.getHighestBlockYAt(x, z);
        if (y > 120) {
            y = 80;
        }
        return y;
    }

    private int getEndHeight(World world, int x, int z) {
        int mainIslandHeight;
        for (int y = mainIslandHeight = 65; y >= world.getMinHeight(); --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            if (type != Material.AIR && type != Material.END_STONE && type != Material.OBSIDIAN || type != Material.END_STONE && type != Material.OBSIDIAN || !this.isAirOrReplaceable(typeAbove)) continue;
            return y + 1;
        }
        return mainIslandHeight + 1;
    }

    private boolean isSolidGround(Material material) {
        return !material.isAir() && material.isSolid() && material != Material.WATER && material != Material.LAVA && !material.name().toUpperCase().endsWith("_LEAVES") && !material.name().toUpperCase().endsWith("_LOG") && !material.name().toUpperCase().endsWith("_WOOD");
    }

    private boolean isAirOrReplaceable(Material material) {
        return material.isAir() || !material.isSolid() || material.name().toUpperCase().endsWith("_LEAVES") || material == Material.TALL_GRASS || material == Material.GRASS || material == Material.FERN || material == Material.LARGE_FERN;
    }

    private boolean hasSuitableBiome(Location location) {
        List<DangData> dangs = this.configManager.getDangManager().getDangs();
        if (dangs.isEmpty()) {
            return true;
        }
        Biome locationBiome = location.getWorld().getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        for (DangData dangData : dangs) {
            if (!dangData.getWorld().equalsIgnoreCase(location.getWorld().getName())) continue;
            for (Biome allowedBiome : dangData.getBiome()) {
                if (allowedBiome != locationBiome) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLocationSafe(Location loc) {
        Material type = loc.getBlock().getType();
        Material typeBelow = loc.clone().subtract(0.0, 1.0, 0.0).getBlock().getType();
        return type.isAir() && this.isSolidGround(typeBelow) && type != Material.WATER && type != Material.LAVA && loc.getBlockY() > loc.getWorld().getMinHeight() && loc.getBlockY() < loc.getWorld().getMaxHeight();
    }

    private int getSuitableHeight(World world, int x, int z) {
        WorldHeightManager.WorldHeightConfig heightConfig = this.configManager.getWorldHeightManager().getHeightConfigForWorld(world);
        if (!heightConfig.isUseDefaultAlgorithm()) {
            return this.random.nextInt(heightConfig.getMaxY() - heightConfig.getMinY() + 1) + heightConfig.getMinY();
        }
        World.Environment env = world.getEnvironment();
        switch (env) {
            case NORMAL: {
                return this.getSurfaceHeight(world, x, z, heightConfig);
            }
            case NETHER: {
                return this.getNetherHeight(world, x, z, heightConfig);
            }
            case THE_END: {
                return this.getEndHeight(world, x, z, heightConfig);
            }
        }
        return this.getSurfaceHeight(world, x, z, heightConfig);
    }

    private int getSurfaceHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        int maxY;
        int minY = config.getMinY();
        for (int y = maxY = config.getMaxY(); y >= minY; --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type)) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    private int getNetherHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        int minY = config.getMinY();
        int maxY = config.getMaxY();
        for (int y = minY; y <= maxY; ++y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            Material typeBelow = world.getBlockAt(x, y - 1, z).getType();
            if (!this.isSolidGround(typeBelow) || !this.isAirOrReplaceable(type) || !this.isAirOrReplaceable(typeAbove)) continue;
            return y;
        }
        return (minY + maxY) / 2;
    }

    private int getEndHeight(World world, int x, int z, WorldHeightManager.WorldHeightConfig config) {
        int maxY;
        int minY = config.getMinY();
        for (int y = maxY = config.getMaxY(); y >= minY; --y) {
            Material type = world.getBlockAt(x, y, z).getType();
            Material typeAbove = world.getBlockAt(x, y + 1, z).getType();
            if (type != Material.END_STONE && type != Material.OBSIDIAN || !this.isAirOrReplaceable(typeAbove)) continue;
            return y + 1;
        }
        return (minY + maxY) / 2;
    }
}

