/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import com.sk89q.worldedit.math.BlockVector3;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.dung.DungActions;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.UndoUtil;

public class SchemCommand
implements CommandExecutor {
    private final DungActions dungActions;
    private final RDang plugin;
    private final ConfigManager configManager;
    private final Storage shulkers;
    private final UndoUtil undoUtil;

    public SchemCommand(DungActions dungActions, RDang plugin, ConfigManager configManager, Storage shulkers, UndoUtil undoUtil) {
        this.dungActions = dungActions;
        this.plugin = plugin;
        this.configManager = configManager;
        this.shulkers = shulkers;
        this.undoUtil = undoUtil;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("only-player")));
            return true;
        }
        Player player = (Player)commandSender;
        if (args.length != 2) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("schem.usage")));
            return true;
        }
        String schemName = args[1];
        File schemFile = this.findSchematicFile(schemName);
        if (schemFile == null || !schemFile.exists()) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("schem.not-found").replace("{schem}", schemName)));
            return true;
        }
        String fileNameOnly = schemFile.getName();
        if (!this.isSchematicRegistered(fileNameOnly)) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("schem.not-registered").replace("{schem}", fileNameOnly)));
            return true;
        }
        Location spawnLocation = player.getLocation().add(player.getLocation().getDirection().multiply(3));
        spawnLocation.setY((double)player.getWorld().getHighestBlockYAt(spawnLocation.getBlockX(), spawnLocation.getBlockZ()));
        try {
            int freeId = this.dungActions.findFreeRegionId();
            String regionName = this.configManager.getRegion().getString("region.name_format", "dang_{id}").replace("{id}", String.valueOf(freeId));
            this.dungActions.getSchemAction().createBackup(spawnLocation, regionName);
            this.dungActions.getSchemAction().spawnSchem(spawnLocation, fileNameOnly);
            int rx = this.configManager.getRegion().getInt("region.size.x", 12);
            int rz = this.configManager.getRegion().getInt("region.size.z", 12);
            int minY = this.configManager.getRegion().getInt("region.height.min", -10);
            int maxY = this.configManager.getRegion().getInt("region.height.max", 10);
            this.dungActions.getAddShulkers().addShulkersInRegion(spawnLocation, rx, rz, minY, maxY);
            this.dungActions.createRegionWithId(spawnLocation.getBlockX(), spawnLocation.getBlockZ(), spawnLocation.getWorld(), freeId);
            this.undoUtil.saveDungeonData(regionName, spawnLocation.getWorld(), BlockVector3.at((int)(spawnLocation.getBlockX() - rx), (int)minY, (int)(spawnLocation.getBlockZ() - rz)));
            player.sendMessage(MessageUtil.colorize(this.getMessage("schem.success").replace("{schem}", fileNameOnly).replace("{x}", String.valueOf(spawnLocation.getBlockX())).replace("{y}", String.valueOf(spawnLocation.getBlockY())).replace("{z}", String.valueOf(spawnLocation.getBlockZ()))));
            return true;
        }
        catch (Exception e) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("schem.error").replace("{schem}", fileNameOnly)));
            e.printStackTrace();
            return true;
        }
    }

    private File findSchematicFile(String name) {
        File folder = new File(this.plugin.getDataFolder(), "schem");
        if (name.toLowerCase().endsWith(".schem") || name.toLowerCase().endsWith(".schematic")) {
            return new File(folder, name);
        }
        File f1 = new File(folder, name + ".schem");
        return f1.exists() ? f1 : new File(folder, name + ".schematic");
    }

    private boolean isSchematicRegistered(String fileName) {
        return this.configManager.getDangManager().getDangs().stream().anyMatch(d -> d.getFileName().equalsIgnoreCase(fileName));
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

