/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;

public class ReloadCommand
implements CommandExecutor {
    private final ConfigManager configManager;
    private final Storage items;
    private final Storage shulkers;

    public ReloadCommand(ConfigManager configManager, Storage items, Storage shulkers) {
        this.configManager = configManager;
        this.items = items;
        this.shulkers = shulkers;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 1) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("reload.usage")));
            return true;
        }
        this.configManager.reloadAll();
        this.items.reloadConfig();
        this.shulkers.reloadConfig();
        sender.sendMessage(MessageUtil.colorize(this.getMessage("reload.success")));
        return true;
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

