/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.menu.MenuManager;
import ru.truhot.rdang.util.MessageUtil;

public class ListCommand
implements CommandExecutor {
    private final ConfigManager configManager;
    private final MenuManager menuManager;

    public ListCommand(ConfigManager configManager, MenuManager menuManager) {
        this.configManager = configManager;
        this.menuManager = menuManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("only-player")));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("rdang.admin")) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("no-permission")));
            return true;
        }
        if (args.length > 1) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("list.usage")));
            return true;
        }
        this.menuManager.openDungeonList(player, 0);
        return true;
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

