/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands.impl;

import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.\u0441ore.MainCore;

public class AddItemCommand
implements CommandExecutor {
    private final MainCore mainCore;
    private final ConfigManager configManager;

    public AddItemCommand(MainCore mainCore, ConfigManager configManager) {
        this.mainCore = mainCore;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("only-player")));
            return true;
        }
        Player player = (Player)commandSender;
        if (args.length != 4) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("additem.usage")));
            return true;
        }
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand.getType() == Material.AIR) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("additem.empty-hand")));
            return true;
        }
        try {
            int chance = Integer.parseInt(args[1]);
            int min = Integer.parseInt(args[2]);
            int max = Integer.parseInt(args[3]);
            if (chance < 1 || chance > 100) {
                player.sendMessage(MessageUtil.colorize(this.getMessage("additem.chance-range")));
                return true;
            }
            if (min < 1 || max < 1) {
                player.sendMessage(MessageUtil.colorize(this.getMessage("additem.amount-positive")));
                return true;
            }
            if (min > max) {
                player.sendMessage(MessageUtil.colorize(this.getMessage("additem.min-max")));
                return true;
            }
            String uuid = UUID.randomUUID().toString();
            this.mainCore.addItem(uuid, hand, chance, min, max);
            player.sendMessage(MessageUtil.colorize(this.getMessage("additem.success")));
            return true;
        }
        catch (NumberFormatException e) {
            player.sendMessage(MessageUtil.colorize(this.getMessage("additem.invalid-numbers")));
            return true;
        }
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

