/*
 * Decompiled with CFR 0.152.
 */
package ru.truhot.rdang.comands;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import ru.truhot.rdang.RDang;
import ru.truhot.rdang.comands.impl.AddItemCommand;
import ru.truhot.rdang.comands.impl.GiveCompassCommand;
import ru.truhot.rdang.comands.impl.GiveKeyCommand;
import ru.truhot.rdang.comands.impl.ListCommand;
import ru.truhot.rdang.comands.impl.ReloadCommand;
import ru.truhot.rdang.comands.impl.SchemCommand;
import ru.truhot.rdang.comands.impl.SpawnCommand;
import ru.truhot.rdang.comands.impl.UndoCommand;
import ru.truhot.rdang.config.ConfigManager;
import ru.truhot.rdang.dung.DungActions;
import ru.truhot.rdang.menu.MenuManager;
import ru.truhot.rdang.storage.Storage;
import ru.truhot.rdang.util.MessageUtil;
import ru.truhot.rdang.util.UndoUtil;
import ru.truhot.rdang.\u0441ore.MainCore;

public class Command
implements CommandExecutor {
    private final RDang plugin;
    private final ConfigManager configManager;
    private final AddItemCommand addItemCommand;
    private final SpawnCommand spawnCommand;
    private final GiveKeyCommand giveKeyCommand;
    private final ReloadCommand reloadCommand;
    private final GiveCompassCommand giveCompassCommand;
    private final SchemCommand schemCommand;
    private final UndoCommand undoCommand;
    private final ListCommand listCommand;
    private final UndoUtil undoUtil;

    public Command(MainCore mainCore, DungActions dungActions, RDang plugin, Storage items, Storage shulkers, Storage block, ConfigManager configManager, MenuManager menuManager, UndoUtil undoUtil) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.undoUtil = undoUtil;
        this.addItemCommand = new AddItemCommand(mainCore, configManager);
        this.spawnCommand = new SpawnCommand(dungActions, configManager);
        this.giveKeyCommand = new GiveKeyCommand(configManager);
        this.reloadCommand = new ReloadCommand(configManager, items, shulkers);
        this.giveCompassCommand = new GiveCompassCommand(configManager);
        this.schemCommand = new SchemCommand(dungActions, plugin, configManager, shulkers, undoUtil);
        this.undoCommand = new UndoCommand(configManager, shulkers, block, plugin);
        this.listCommand = new ListCommand(configManager, menuManager);
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("rdang.admin")) {
            sender.sendMessage(MessageUtil.colorize(this.getMessage("no-permission")));
            return true;
        }
        if (args.length == 0) {
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "additem": {
                return this.addItemCommand.onCommand(sender, command, label, args);
            }
            case "spawn": {
                return this.spawnCommand.onCommand(sender, command, label, args);
            }
            case "schem": {
                return this.schemCommand.onCommand(sender, command, label, args);
            }
            case "givekey": {
                return this.giveKeyCommand.onCommand(sender, command, label, args);
            }
            case "compass": {
                return this.giveCompassCommand.onCommand(sender, command, label, args);
            }
            case "reload": {
                return this.reloadCommand.onCommand(sender, command, label, args);
            }
            case "undo": {
                return this.undoCommand.onCommand(sender, command, label, args);
            }
            case "list": {
                return this.listCommand.onCommand(sender, command, label, args);
            }
        }
        String unknownMsg = this.getMessage("unknown-command").replace("{command}", subCommand);
        sender.sendMessage(MessageUtil.colorize(unknownMsg));
        return true;
    }

    private String getMessage(String path) {
        return this.configManager.getMessages().getString("messages." + path, "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + path);
    }
}

